﻿/******************************************************************/
/*                                                                */
/*            Author: Frédéric ROBIN (robinfredericf)             */
/*                                                                */
/*        http://robinfredericf.free.fr                           */
/*        http://fr.viadeo.com/fr/profile/robinfredericf          */
/*        http://plus.google.com/u/0/112815740483397412444        */
/*                                                                */
/*                    robinfredericfҨgmaїl·cѳm                    */
/*                                                                */
/******************************************************************/

#target "InDesign"

$.localize = true;
$.locale = null;
//$.locale = "en";

/*
    Evolution du script  changer-zone-page-import-pdf_indd002 
    lequel était destiné à réimporter un pdf ou un indd (la même page) en changeant le cadrage 
    (exemple : passer de la zone de rogne à la zone de fond perdu) sans bouger, c'est à dire 
    EN CONSERVANT LA MÊME ÉCHELLE et le même centrage dans le bloc image
    (mais les remplacements de visibilité des calques n'étaient pas conservés)
    Le positionnement du graphique sera le même si l'ancienne et la nouvelle zone de page sont
    centrées l'une par rapport à l'autre (exemple : Zone de rogne -> Zone de fond perdu symétrique)
    dans le cas contraire le graphique aura la même échelle mais semblera être déplacé
    (exemple : Zone de rogne -> Cadre de sélection)
    
    L'utilisation de true pour la variable showingOptions de 
    PageItem.place (fileName: File[, showingOptions: bool=false][, withProperties: Object])
    telle qu'utilisée dans PDFoptions_editor / JR Boulay - Fevrier 2010 - http://abracadabraPDF.net
    permet d'éviter d'avoir à créer un dialogue personnalisé pour la sélection de la zone de page
    et permet de changer les autres options (numéro de page, visibilité des calques).
    Le dialogue ouvert par .place sélectionne par défaut la zone de page précédemment utilisée
    mais pas la page précedemment importée, par défaut il revient à la première page du pdf.
*/

var selectionContenuAuLieuDeContenant = new Boolean (false);

function appliquerATousLesBlocsSelectionnes () {
    var lesBlocs = app.activeDocument.selection;
    var nouvelleSelection = [];
    for (var i=0; i<lesBlocs.length; i++) {
        lesBlocs[i].select(SelectionOptions.REPLACE_WITH);
        var leBloc, leGraphique;
        try {
            leBloc = lesBlocs[i];
            leGraphique = leBloc.pageItems[0];
            selectionContenuAuLieuDeContenant = false;
        }
        catch (e) {
            leGraphique = lesBlocs[i];
            leBloc = leGraphique.parent;
            selectionContenuAuLieuDeContenant = true;
        }
        if (
                leBloc && leGraphique 
                && leBloc.contentType === ContentType.graphicType
                && 'itemLink' in leGraphique
        ) {
            try {
                nouvelleSelection.push (reediterOptionsDuLien (leBloc, leGraphique));
            } catch (e) { continue; }
        } else {
            alert ({fr:"Aucun lien à rééditer dans l'élément sélectionné.",en:"No link to edit in the selected item."});
        }
    }
    app.activeDocument.select (nouvelleSelection, SelectionOptions.REPLACE_WITH);
    return nouvelleSelection;
}

function reediterOptionsDuLien(leBloc, leGraphique) {
    //var isIndd = ('importedPageCrop' in leGraphique);
    //var isPdf = ('pdfAttributes' in leGraphique);
    // donne "true" pour les deux à la fois
    var isIndd = (leGraphique.imageTypeName === 'InDesign');
    var isPdf = (leGraphique.imageTypeName === 'Adobe PDF');
    //alert (isIndd +"\r\n" + isPdf);

    var ge = [
        leGraphique.absoluteHorizontalScale,
        leGraphique.absoluteVerticalScale
    ];
    var gb = leGraphique.geometricBounds;
    var bc = leBloc.frameFittingOptions.properties;
    
    if (isPdf) {
        app.pdfPlacePreferences.pageNumber = leGraphique.pdfAttributes.pageNumber; 
        // hélas sans effet sur la fenêtre d'édition de lien ouverte ensuite par .place
        // il est apparemment également impossible d'y conserver par défaut la valeur de leGraphique.graphicLayerOptions.updateLinkOption
        app.pdfPlacePreferences.pdfCrop = leGraphique.pdfAttributes.pdfCrop;
        app.pdfPlacePreferences.transparentBackground = leGraphique.pdfAttributes.transparentBackground;
    } 
    if (isIndd) {
        app.importedPageAttributes.pageNumber = leGraphique.pageNumber;
        app.importedPageAttributes.importedPageCrop = leGraphique.importedPageCrop;
    }
    leBloc.place(
        File (leGraphique.itemLink.filePath),
        true,
        undefined
    );
    //La réédition du lien rend invalide la référence à l'objet leGraphique qu'il faut donc redéfinir
    leGraphique = leBloc.pageItems[0];
    leBloc.frameFittingOptions.properties = bc;
    //leGraphique.select();
    
    if (
        leGraphique.geometricBounds.toString() !== gb.toString() ||
        [ leGraphique.absoluteHorizontalScale, leGraphique.absoluteVerticalScale].toString() !== ge.toString()
    ) {
        /*
            La suite est destinée à rétablir l'échelle et le centrage du Graphique pour qu'il ne bouge 
            pas, dans le cas où ils auraient changé à la suite de la réédition du lien, ce qui arrive 
            quand le graphique est un pdf ou un indd et que la zone de page importée n'est plus la même. 
        */
        //Restauration de l'échelle
        leGraphique.absoluteHorizontalScale = ge[0];
        leGraphique.absoluteVerticalScale   = ge[1];
        //Recentrage du Graphique par rapport au centre de la position qu'il occupait avant la réédition du lien
        leGraphique.move (
            undefined, // pour avoir "move by" (vers une coordonnée relative) au lieu de "move to" (vers une coordonnée absolue)
            [
                (gb[3] + gb[1]) / 2 - (leGraphique.geometricBounds[3] + leGraphique.geometricBounds[1]) / 2,
                (gb[2] + gb[0]) / 2 - (leGraphique.geometricBounds[2] + leGraphique.geometricBounds[0]) / 2,
            ]
        );
    }
    return selectionContenuAuLieuDeContenant.valueOf() ? leGraphique : leBloc;
}


try { 
    app.doScript(
        function() { appliquerATousLesBlocsSelectionnes (); },
        ScriptLanguage.JAVASCRIPT,
        undefined,
        UndoModes.ENTIRE_SCRIPT,
        File($.fileName).name
    );
} catch(e) { alert(e); }
