﻿/******************************************************************/
/*                                                                */
/*            Author: Frédéric ROBIN (robinfredericf)             */
/*                                                                */
/*        http://robinfredericf.free.fr                           */
/*        http://www.linkedin.com/in/robinfredericf/en            */
/*        http://fr.viadeo.com/fr/profile/robinfredericf          */
/*        http://plus.google.com/u/0/112815740483397412444        */
/*                                                                */
/*                    robinfredericfҨgmaїl·cѳm                    */
/*                                                                */
/******************************************************************/

#target "InDesign";
#targetengine ManageSingletonPalette;

$.localize = true;
$.locale = null;
//$.locale = "en";


var centVingtSeptMillimetres = {
    /*
        pour chaque unité sélectionnée dans les préférences d'unité de mesure d'InDesign
        on répertorie les dimensions affichées d'un carré de 127 mm.
        Les unités désactivées sont supposées exister d'après
        http://jongware.mit.edu/idcs5js/pc_ViewPreference.html
        mais ne peuvent être sélectionnées ni par la
        fenêtre des préférences ni par javascript.
        Pour CUSTOM « Personnalisées » on est supposé spécifier un nombre de points
        (12 par défaut) mais l'affichage des dimensions est toujours en points.
    */
    POINTS: 360,
    PICAS: 30,
    INCHES: 5,
    INCHES_DECIMAL: 5,
    MILLIMETERS: 127,
    CENTIMETERS: 12.7,
    CICEROS: 84.455/3, //soit 28.1516666666899
    CUSTOM: 360,
    AGATES: 70,
    //U
    //BAI
    //MILS
    PIXELS: 360,
    //Q
    //HA
    //AMERICAN_POINTS
};
function convertUnits (n0, u0, u1) {
    var n1 = n0 * centVingtSeptMillimetres[u1] / centVingtSeptMillimetres[u0];
    //$.writeln (n0 + " " + u0 + " \u2192 " + n1 + " " + u1);
    return n1;
}


function setVerticalTransformReferencePointTo(WhichOne) {
    switch (WhichOne) {
        case 'TOP':
            app.activeWindow.transformReferencePoint = AnchorPoint[{
                BOTTOM_CENTER_ANCHOR : 'TOP_CENTER_ANCHOR',
                BOTTOM_LEFT_ANCHOR   : 'TOP_LEFT_ANCHOR',
                BOTTOM_RIGHT_ANCHOR  : 'TOP_RIGHT_ANCHOR',
                CENTER_ANCHOR        : 'TOP_CENTER_ANCHOR',
                LEFT_CENTER_ANCHOR   : 'TOP_LEFT_ANCHOR',
                RIGHT_CENTER_ANCHOR  : 'TOP_RIGHT_ANCHOR',
                TOP_CENTER_ANCHOR    : 'TOP_CENTER_ANCHOR',
                TOP_LEFT_ANCHOR      : 'TOP_LEFT_ANCHOR',
                TOP_RIGHT_ANCHOR     : 'TOP_RIGHT_ANCHOR',
            }[app.activeWindow.transformReferencePoint]];
            break;
        case 'BOTTOM':
            app.activeWindow.transformReferencePoint = AnchorPoint[{
                BOTTOM_CENTER_ANCHOR : 'BOTTOM_CENTER_ANCHOR',
                BOTTOM_LEFT_ANCHOR   : 'BOTTOM_LEFT_ANCHOR',
                BOTTOM_RIGHT_ANCHOR  : 'BOTTOM_RIGHT_ANCHOR',
                CENTER_ANCHOR        : 'BOTTOM_CENTER_ANCHOR',
                LEFT_CENTER_ANCHOR   : 'BOTTOM_LEFT_ANCHOR',
                RIGHT_CENTER_ANCHOR  : 'BOTTOM_RIGHT_ANCHOR',
                TOP_CENTER_ANCHOR    : 'BOTTOM_CENTER_ANCHOR',
                TOP_LEFT_ANCHOR      : 'BOTTOM_LEFT_ANCHOR',
                TOP_RIGHT_ANCHOR     : 'BOTTOM_RIGHT_ANCHOR',
            }[app.activeWindow.transformReferencePoint]];
            break;
        case 'CENTER':
            app.activeWindow.transformReferencePoint = AnchorPoint[{
                BOTTOM_CENTER_ANCHOR : 'CENTER_ANCHOR',
                BOTTOM_LEFT_ANCHOR   : 'LEFT_CENTER_ANCHOR',
                BOTTOM_RIGHT_ANCHOR  : 'RIGHT_CENTER_ANCHOR',
                CENTER_ANCHOR        : 'CENTER_ANCHOR',
                LEFT_CENTER_ANCHOR   : 'LEFT_CENTER_ANCHOR',
                RIGHT_CENTER_ANCHOR  : 'RIGHT_CENTER_ANCHOR',
                TOP_CENTER_ANCHOR    : 'CENTER_ANCHOR',
                TOP_LEFT_ANCHOR      : 'LEFT_CENTER_ANCHOR',
                TOP_RIGHT_ANCHOR     : 'RIGHT_CENTER_ANCHOR',
            }[app.activeWindow.transformReferencePoint]];
            break;
        default: return false;
    }
}

function whichIsVerticalTransformReferencePoint() {
    return {
        BOTTOM_CENTER_ANCHOR : 'BOTTOM',
        BOTTOM_LEFT_ANCHOR   : 'BOTTOM',
        BOTTOM_RIGHT_ANCHOR  : 'BOTTOM',
        CENTER_ANCHOR        : 'CENTER',
        LEFT_CENTER_ANCHOR   : 'CENTER',
        RIGHT_CENTER_ANCHOR  : 'CENTER',
        TOP_CENTER_ANCHOR    : 'TOP',
        TOP_LEFT_ANCHOR      : 'TOP',
        TOP_RIGHT_ANCHOR     : 'TOP',
    }[app.activeWindow.transformReferencePoint];
}

Paragraph.prototype.isFirstInColumn = function () {
    var previous = this.parentStory.paragraphs.previousItem(this);
    return (
        (! previous.isValid) ||
        (previous.textColumns[0].index !== this.textColumns[0].index)
    );
};

Paragraph.prototype.isLastInColumn = function () {
    var next = this.parentStory.paragraphs.nextItem(this);
    return (
        (! next.isValid) ||
        (next.textColumns[0].index !== this.textColumns[0].index)
    );
};


function getParentPageOrNearestPage /*NearestPageForItemOutOfPage*/ (item) {
    if ('parentPage' in item && item.parentPage !== null) { return item.parentPage; }
    /*
        Si un pageItem n'a pas de parentPage il est probablement en dehors d'une page sur la table de montage. 
        En remontant dans la hiérarchie de ses parents on finira par atteindre une planche (Spread/MasterSpread). 
        Dans le cas d'un objet ancré il faut remonter dans ses parents en bifurquant vers parentTextFrames[0] 
        sans quoi ses parents seront Character > Story > Document > Application 
    */
    if ('parentTextFrames' in item) { return getParentPageOrNearestPage (item.parentTextFrames[0]); }
    //$.writeln (item.constructor.name);
    switch (item.constructor.name) {
        case 'Document' :     return item.pages[0];
        case 'MasterSpread' : return item.pages[0];
        case 'Spread' :       return item.pages[0];
        case 'Page' :         return item;
        default: return getParentPageOrNearestPage (item.parent);
    }
}


var tolerance = 1e-9;
var prefs = "prefs_"+File($.fileName).name;
if (! (prefs in $.global)) {
    $.global[prefs] = {
        afficheBaseline: new String(''),
        actionARealiser: new Number(0),
        compenserParangonnage: new Boolean(true),
    };
}

var afficheBaseline, actionARealiser, compenserParangonnage;

$.UserInterface || ($.UserInterface = function F(FLAG)
//--------------------------------------
// FLAG == -1  => destroy
// FLAG ==  0  => restore
// FLAG ==  1  => rebuild
{
    F.W || (F.W=Window.find('palette', File($.fileName).name));
 
    // Destroy?
    // ---
    if( F.W && FLAG )
        {
        F.W.visible && F.W.close();
        F.W = null;
        delete F.W;
        }
 
    if( -1===FLAG ) return;
 
    // Create?
    // ---
    if( !F.W )
        {
        F.W = new Window ('palette', File($.fileName).name);

        with (F.W.add ('group',undefined,undefined,{orientation:'row'})) {
            afficheBaseline = add ('edittext', undefined, $.global[prefs].afficheBaseline);
            afficheBaseline.characters = 32;
            boutonAjouterRepere = add ('button', undefined, {en:"Add guide",fr:"Ajouter un repère"});
        }

        function ajouterRepere() {
            afficheBaseline.text = afficheBaseline.text.replace (/\,/g, '.');
            with (app.activeWindow.activePage.guides.add (app.activeDocument.activeLayer)) {
                orientation = HorizontalOrVertical.HORIZONTAL;
                location = Number (eval (afficheBaseline.text));
            }
        }

        boutonAjouterRepere.onClick = function() {
            try {
                app.doScript(
                    function() { ajouterRepere (); },
                    ScriptLanguage.JAVASCRIPT,
                    undefined,
                    UndoModes.ENTIRE_SCRIPT,
                    this.text
                );
            } catch(e) { alert(e); }
        };

        with (F.W.add ('group',undefined,undefined,{orientation:'row'})) {
            var boutonCopierBaseline = add ('button', undefined, {en:"Copy baseline", fr:"Copier la ligne de base"});
            var boutonCollerBaseline = add ('button', undefined, {en:"Paste baseline",fr:"Coller la ligne de base"});
        }
        boutonCopierBaseline.onClick = function () { try {
            var c = app.activeDocument.selection[0].characters[0];
            var yUnit = app.activeDocument.viewPreferences.verticalMeasurementUnits;
            var tf = c.parentTextFrames[0];
            var yScale = tf.verticalScale / 100;
            var baselineSouhaitee = c.baseline;
            if (! compenserParangonnage.value) { baselineSouhaitee += convertUnits(c.baselineShift, 'POINTS', yUnit) * yScale; }
            afficheBaseline.text = baselineSouhaitee;
        } catch (e) { alert (e); } };



        actionARealiser = F.W.add (
            'dropdownlist',
            undefined,
            [
                /*0*/ {
                    en:"Modify text frame minimum 1st baseline offset",
                    fr:"Modifier décalage minimum 1re ligne de base du bloc"
                },
                /*1*/ {
                    en:"Modify text frame inset spacing",
                    fr:"Modifier les marges intérieures du bloc"
                },
                /*2*/ {
                    en:"Move text frame vertically",
                    fr:"Déplacer le bloc verticalement"
                },
                /*3*/ {
                    en:"Modify characters baseline shift",
                    fr:"Modifier le décalage vertical des caractères"
                },
                /*4*/ {
                    en:"Modify paragraph leading",
                    fr:"Modifier l'interlignage du paragraphe"
                },
                /*5*/ {
                    en:"Modify paragraph space before/after",
                    fr:"Modifier espace avant/après paragraphe"
                },
                /*6*/ {
                    en:"Modify space after previous paragraph/space before next paragraph",
                    fr:"Modifier espace après paragraphe précédent/avant paragraphe suivant"
                },
                /*7*/ {
                    en:"Resize text frame",
                    fr:"Redimensionner le bloc"
                },
                /*8*/ {
                    en:"Scale text frame",
                    fr:"Mettre le bloc à l'échelle"
                }
            ]
        );
        actionARealiser.selection = $.global[prefs].actionARealiser;

        compenserParangonnage = F.W.add ('checkbox', undefined, {en:"including baseline shift offset",fr:"décalage vertical inclus"});
        compenserParangonnage.value = $.global[prefs].compenserParangonnage.valueOf();

        boutonCollerBaseline.onClick = function () {
            try {
                app.doScript(
                    function() { 
                        while (collerBaseline () === 2) {}
                    },
                    ScriptLanguage.JAVASCRIPT,
                    undefined,
                    UndoModes.ENTIRE_SCRIPT,
                    this.text + " (" + actionARealiser.selection.text + ")"
                );
            } catch(e) { alert(e || errMsg); }
        };

        F.W.onClose = function () {
            $.global[prefs].afficheBaseline = afficheBaseline.text;
            $.global[prefs].actionARealiser = actionARealiser.selection.index;
            $.global[prefs].compenserParangonnage = compenserParangonnage.value;
        };
    }
 
    F.W.visible || F.W.show();
});
 
// use -1 to KILL the palette, 1 to REBUILD it from scratch
$.UserInterface();
 
function collerBaseline () {

$.localize = true;
$.locale = null;
//$.locale = "en";
//errMsg = '';
    var retry = false;
    afficheBaseline.text = afficheBaseline.text.replace (/\,/g, '.');
    var yctrg = Number (eval (afficheBaseline.text));
    if (isNaN (yctrg)) { return false; }
    var yUnit = app.activeDocument.viewPreferences.verticalMeasurementUnits;
    var c = app.activeDocument.selection[0].characters[0];
    var p = c.paragraphs[0];
    var tf = c.parentTextFrames[0];
    var yScale = tf.verticalScale / 100;
    var ycsrc = c.baseline;
    if (! compenserParangonnage.value) { ycsrc += convertUnits (c.baselineShift, 'POINTS', yUnit) * yScale; }
    var dyc = yctrg - ycsrc;
        
    if (tf.textFramePreferences.verticalJustification === VerticalJustification.JUSTIFY_ALIGN) {
        var c0 = tf.characters.firstItem();
        var yc0src = c0.baseline;
        var c1 = tf.characters.lastItem();
        var yc1src = c1.baseline;
        /* niltf nombre total d'espaces inter-lignes dans tf */
        var niltf = tf.lines.length - 1;
        /* nilc0c et nilcc1 nombres d'espaces inter-lignes dans tf au dessus et au dessous de c */
        var nilc0c = tf.characters.itemByRange (c0, c).getElements()[0].lines.length - 1;
        var nilcc1 = tf.characters.itemByRange (c, c1).getElements()[0].lines.length - 1;
        //var nilcc1 = niltf - nilc0c -1;
        /* niptf nombre total d'espaces inter-paragraphes dans tf */
        var niptf = tf.paragraphs.length - 1;
        /* nipc0c et nipcc1 nombres d'espaces inter-paragraphes dans tf au dessus et au dessous de c */
        var nipc0c = tf.characters.itemByRange (c0, c).getElements()[0].paragraphs.length - 1;
        var nipcc1 = tf.characters.itemByRange (c, c1).getElements()[0].paragraphs.length - 1;
        //var nipcc1 = niptf - nipc0c - 1;
        var vt = tf.textFramePreferences.verticalThreshold * yScale;
        var tfprefs = tf.textFramePreferences.properties;
        tf.textFramePreferences.verticalJustification = VerticalJustification.TOP_ALIGN;
        var yc0TA = c0.baseline;
        var ycTA = c.baseline;
        if (! compenserParangonnage.value) { ycTA += convertUnits (c.baselineShift, 'POINTS', yUnit) * yScale; }
        var yc1TA = c1.baseline;
        tf.textFramePreferences.verticalJustification = VerticalJustification.BOTTOM_ALIGN;
        var yc0BA = c0.baseline;
        var ycBA = c.baseline;
        if (! compenserParangonnage.value) { ycBA += convertUnits (c.baselineShift, 'POINTS', yUnit) * yScale; }
        var yc1BA = c1.baseline;
        tf.textFramePreferences.properties = tfprefs;
        /* tstf espace total occupé par le texte dans tf par la justification verticale par rapport à l'alignement vertical en haut */
        var tstf = yc1src - yc1TA;
        var tsc0c = ycsrc - ycTA;
        var tscc1 = tstf - tsc0c;
        var dsp, dsl;
    }


    function fff1 (gb) {
        switch (tf.textFramePreferences.verticalJustification) {
        case VerticalJustification.TOP_ALIGN:
            gb[0] += dyc; break;
        case VerticalJustification.BOTTOM_ALIGN:
            gb[2] += dyc; break;
        case VerticalJustification.CENTER_ALIGN:
            switch (whichIsVerticalTransformReferencePoint()) {
                case 'TOP':
                    gb[2] += 2 * dyc;
                    break;
                case 'BOTTOM':
                    gb[0] += 2 * dyc;
                    break;
                case 'CENTER':
                    gb[0] += dyc;
                    gb[2] += dyc;
                    break;
            }
            break;
            
        case VerticalJustification.JUSTIFY_ALIGN:

            var htfsrc = gb[2] - gb[0];
            var htfmin = htfsrc - tstf;
            var htfvt = htfmin + niptf * vt;
            
            var d1htf = htfvt - htfsrc;
            if (d1htf >= 0) {
                dsl = 0;
                dsp = d1htf / niptf;
            } else { /*if (d1htf < 0)*/ 
                dsp = 0;
                dsl = d1htf / niltf;
            }
        
            var ycvt, dycvt, d2htfp, d2htfl, d2htf;

            switch (whichIsVerticalTransformReferencePoint()) {
                
                case 'TOP':
                    gb[2] += d1htf;
                    if (dsp) {
                        ycvt = ycsrc + dsp * nipc0c;
                    } else {
                        ycvt = ycsrc + dsl * nilc0c;
                    }
                    dycvt = yctrg - ycvt;
                    d2htfp = dycvt / (nipc0c / niptf);
                    d2htfl = dycvt / (nilc0c / niltf);
                    d2htf = (d2htfp >= 0) ? d2htfl : d2htfp;
                    gb[2] += d2htf;
                    break;
                    
                case 'BOTTOM':
                    gb[0] -= d1htf;
                    if (dsp) {
                        ycvt = ycsrc - dsp * nipcc1;
                    } else {
                        ycvt = ycsrc - dsl * nilcc1;
                    }
                    dycvt = yctrg - ycvt;
                    d2htfp = - dycvt / (nipcc1 / niptf);
                    d2htfl = - dycvt / (nilcc1 / niltf);
                    d2htf = (d2htfp >= 0) ? d2htfl : d2htfp;
                    gb[0] -= d2htf;
                    break;
                    
                case 'CENTER':
                    gb[0] -= d1htf / 2;
                    gb[2] += d1htf / 2;
                    if (dsp) {
                        ycvt = ycsrc - d1htf / 2 + dsp * nipc0c;
                    } else {
                        ycvt = ycsrc - d1htf / 2 + dsl * nilc0c;
                    }
                    dycvt = yctrg - ycvt;
                    d2htfp = dycvt / (nipc0c / niptf - .5);
                    d2htfl = dycvt / (nilc0c / niltf - .5);
                    d2htf = (d2htfp >= 0) ? d2htfl : d2htfp;
                    gb[0] -= d2htf / 2;
                    gb[2] += d2htf / 2;
                    break;
            }
            break;
        }
        return gb;
    }
    var is;


    switch (actionARealiser.selection.index) {



        /*================================================================================================================================*/
        case 0: /*"Modifier décalage 1re ligne de base du bloc"*/
        /*================================================================================================================================*/
        
            setVerticalTransformReferencePointTo('BOTTOM');
            if (tf.textFramePreferences.verticalJustification === VerticalJustification.BOTTOM_ALIGN) {
                    throw new Error(errMsg = actionARealiser.selection.text + {
                        en: " won't have any effect on text bottom-aligned in the text frame!",
                        fr:" sera sans effet sur du texte aligné en pied dans le bloc !"
                    });
            }
            
            is = {
                0: tf.textFramePreferences.minimumFirstBaselineOffset,
                2: 0 
            };
            is[0] *= yScale; is[2] *= - yScale; 
            is = fff1 (is); 
            is[0] /= yScale; is[2] /= - yScale; 
            
            if (is[0] < 0 && tf.textFramePreferences.firstBaselineOffset !== FirstBaseline.FIXED_HEIGHT) {
                retry = true;
            } else {
                tf.textFramePreferences.minimumFirstBaselineOffset = is[0];
            }
            break;



        /*================================================================================================================================*/
        case 1: /*"Modifier la marge intérieure du bloc"*/
        /*================================================================================================================================*/
        
            is = tf.textFramePreferences.insetSpacing;
            is[0] *= yScale; is[2] *= - yScale; 
            is = fff1 (is); 
            is[0] /= yScale; is[2] /= - yScale; 
            
            if (is[0] < 0) { is[0] = 0; setVerticalTransformReferencePointTo('TOP');    retry = true; }
            if (is[2] < 0) { is[2] = 0; setVerticalTransformReferencePointTo('BOTTOM'); retry = true; }
            tf.textFramePreferences.insetSpacing = is;
            break;



        /*================================================================================================================================*/
        case 2: /*"Déplacer le bloc verticalement"*/
        /*================================================================================================================================*/
        
            tf.move (
                undefined,
                [ 0, dyc ]
            );
            break;



        /*================================================================================================================================*/
        case 3: /*"Modifier parangonnage"*/
        /*================================================================================================================================*/
        
            app.activeDocument.selection[0].texts[0].baselineShift = c.baselineShift - convertUnits (dyc, yUnit, 'POINTS') / yScale;
            break;



        /*================================================================================================================================*/
        case 4: /*"Modifier interlignage"*/
        /*================================================================================================================================*/
        
            if (! app.activeDocument.textPreferences.useParagraphLeading) {
                if (confirm ({
                    en:"Set document preference to «Use paragraph leading»?",
                    fr:"Régler la préférence du document sur « Appliquer l'interligne à l'ensemble du paragraphe » ?"
                })) {
                    app.activeDocument.textPreferences.useParagraphLeading = true;
                    c.leading = .1;
                    retry = true;
                } else { 
                    throw new Error (errMsg = actionARealiser.selection.text + {
                        en: " only works with preference «Use paragraph leading». \r\n"
                        +"Otherwise modify the leading of selected characters won't move them to the desired coordinate because their position "
                        +"will depend of the highest leading among other characters located on the same paragraph line. ",
                        fr:" ne marche qu'avec la préférence « Appliquer l'interligne à l'ensemble du paragraphe ». \r\n"
                        +"Sans quoi modifier l'interlignage des caractères séléctionnés ne suffira pas à les déplacer verticalement jusqu'à "
                        +"la coordonnée voulue vu que leur position dépendra de l'interlignage le plus élevé parmi ceux des autres caractères "
                        +"situés sur la même ligne du même paragraphe."
                    });
                }
            }
            if (c.leading === Leading.AUTO) { 
                //c.leading = c.pointSize * c.autoLeading / 100;
                /* 
                    Pour Leading.AUTO l'interlignage est proportionnel au corps de chaque caractère même avec la préférence useParagraphLeading 
                    et donc le même problème que signalé dans l'erreur ci dessus :
                    si le paragraphe comporte des caractères de différents corps on a souvent pas le même interlignage pour toutes les lignes.
                    Le seul moyen est celui utilisé dans les précédentes versions, avant de mesurer ycsrc initialiser l'interlignage en remplaçant
                    "Auto" par une valeur (la plus faible possible pour éviter que du texte devienne en excès)
                */
                c.leading = .1;
                /* pour une valeur de zéro l'interlignage n'est pas exactement nul mais égal à .01 pt (.0035277777777 mm). */
                retry = true;
            }
            /* Inutile de perdre du temps à exécuter le reste, autant interrompre la fonction et recommencer */
            if (retry === true) { return 2; }
            
            /* c est situé dans la nlp0c -ième ligne du paragraphe p */
            var nlp0c = c.parentStory.characters.itemByRange (p.characters[0], c).getElements()[0].lines.length;
            var nlpc1 = p.lines.length - nlp0c;
            if (p.isFirstInColumn() && tf.textFramePreferences.firstBaselineOffset !== FirstBaseline.LEADING_OFFSET) { nlp0c--; }
            switch (tf.textFramePreferences.verticalJustification) {
                case VerticalJustification.TOP_ALIGN:
                    if (nlp0c === 0) { throw new Error (errMsg = actionARealiser.selection.text + {en:" won't have any effect on the selected text",fr:" n'aura aucun effet sur le texte sélectionné"}); }
                    c.leading += convertUnits (dyc, yUnit, 'POINTS') / yScale / nlp0c;
                    break;
                case VerticalJustification.BOTTOM_ALIGN:
                    if (nlpc1 === 0) { throw new Error (errMsg = actionARealiser.selection.text + {en:" won't have any effect on the selected text",fr:" n'aura aucun effet sur le texte sélectionné"}); }
                    c.leading -= convertUnits (dyc, yUnit, 'POINTS') / yScale / nlpc1;
                    break;
                case VerticalJustification.CENTER_ALIGN:
                    //if (nlp0c === 0) { c.leading -= 2 * convertUnits (dyc, yUnit, 'POINTS') / yScale / nlpc1; }
                    //if (nlpc1 === 0) { c.leading += 2 * convertUnits (dyc, yUnit, 'POINTS') / yScale / nlp0c; }
                    /*cas général*/
                    c.leading += 2 * convertUnits (dyc, yUnit, 'POINTS') / yScale / (nlp0c - nlpc1);
                    break;
                case VerticalJustification.JUSTIFY_ALIGN:
                    var i = convertUnits (c.leading, 'POINTS', yUnit) * yScale;
                    var htfsrc = tf.geometricBounds[2] - tf.geometricBounds[0];
                    var htfmin = htfsrc - tstf;
                    var htfvt = htfmin + niptf * vt;
                    var d1htf = htfvt - htfsrc;
                    var d1i = - d1htf / (nlp0c + nlpc1);
                    var ycvt;
                    if (d1htf >= 0) {
                        dsl = 0;
                        dsp = d1htf / niptf;
                        ycvt = ycsrc + dsp * nipc0c + d1i * nlp0c;
                    }
                    if (d1htf < 0) {
                        dsp = 0;
                        dsl = d1htf / niltf;
                        ycvt = ycsrc + dsl * nilc0c + d1i * nlp0c;
                    }
                    //$.writeln ("ycvt = " + ycvt);
                    var dycvt = yctrg - ycvt;
                    var d2ip = dycvt / ( nlp0c - (nlp0c + nlpc1) * (nipc0c / niptf) );
                    var d2il = dycvt / ( nlp0c - (nlp0c + nlpc1) * (nilc0c / niltf) );
                    var d2i = (d2ip >= 0) ? d2ip : d2il;
                    p.leading = convertUnits (i + d1i + d2i, yUnit, 'POINTS') / yScale;
                    break;
            }
            break;



        /*================================================================================================================================*/
        case 5: /*"Modifier espace avant/après paragraphe"*/
        /*================================================================================================================================*/
        
            is = {
                0: p.spaceBefore,
                2: p.spaceAfter,
            };
            is[0] *= yScale; is[2] *= - yScale; 
            is = fff1 (is); 
            is[0] /= yScale; is[2] /= - yScale; 
            
            if (is[0] < 0) { is[0] = 0; setVerticalTransformReferencePointTo('TOP');    retry = true; }
            if (is[2] < 0) { is[2] = 0; setVerticalTransformReferencePointTo('BOTTOM'); retry = true; }
            p.spaceBefore = is[0];
            p.spaceAfter  = is[2];
            break;



        /*================================================================================================================================*/
        case 6: /*"Modifier espace après paragraphe précédent/avant paragraphe suivant"*/
        /*================================================================================================================================*/
        
            var dummy = {
                previous: { spaceAfter:  0 },
                next:     { spaceBefore: 0 },
            };
            if (p.isFirstInColumn()) {
                dummy.previous.spaceAfter = 0; setVerticalTransformReferencePointTo ('TOP');
            } else {
                dummy.previous.spaceAfter = p.parentStory.paragraphs.previousItem (p).spaceAfter;
            }
            if (p.isLastInColumn()) {
                dummy.next.spaceBefore    = 0; setVerticalTransformReferencePointTo ('BOTTOM');
            } else {
                dummy.next.spaceBefore    = p.parentStory.paragraphs.nextItem     (p).spaceBefore;
            }

            is = {
                    0: dummy.previous.spaceAfter,
                    2: dummy.next.spaceBefore,
            };
            is[0] *= yScale; is[2] *= - yScale; 
            is = fff1 (is); 
            is[0] /= yScale; is[2] /= - yScale; 
            
            if (is[0] < 0) { is[0] = 0; setVerticalTransformReferencePointTo('TOP');    retry = true; }
            if (is[2] < 0) { is[2] = 0; setVerticalTransformReferencePointTo('BOTTOM'); retry = true; }
            dummy.previous.spaceAfter = is[0];
            dummy.next.spaceBefore    = is[2];
            if (! p.isFirstInColumn()) { p.parentStory.paragraphs.previousItem (p).spaceAfter  = dummy.previous.spaceAfter; }
            if (! p.isLastInColumn())  { p.parentStory.paragraphs.nextItem     (p).spaceBefore = dummy.next.spaceBefore;    }
            break;



        /*================================================================================================================================*/
        case 7: /*"Redimensionner le bloc"*/
        /*================================================================================================================================*/
        
            if (
                tf.textFramePreferences.verticalJustification === VerticalJustification.CENTER_ALIGN
                && whichIsVerticalTransformReferencePoint() === 'CENTER'
            ) { 
                setVerticalTransformReferencePointTo('TOP'); 
            }
            tf.geometricBounds = fff1 (tf.geometricBounds);
            break;



        /*================================================================================================================================*/
        case 8: /*"Mettre le bloc à l'échelle"*/
        /*================================================================================================================================*/

            var tfb = tf[app.transformPreferences.dimensionsIncludeStrokeWeight ? 'visibleBounds' : 'geometricBounds'];
            var s = 1;
            switch (whichIsVerticalTransformReferencePoint()) {
                case 'TOP':
                    s = (yctrg - tfb[0]) / (ycsrc - tfb[0]);
                    break;
                case 'BOTTOM':
                    s = (tfb[2] - yctrg) / (tfb[2] - ycsrc);
                    break;
                case 'CENTER':
                    var tfvc = (tfb[0] + tfb[2]) / 2;
                    s = (tfvc - yctrg) / (tfvc - ycsrc);
                    break;
            }
            tf.absoluteVerticalScale *= s;
            /*
                Il n'existe apparemment aucune propriété js, correspondant à une quelconque préférence 
                de l'application, de la fenêtre active ou du document actif, relative à l'état 
                de l'icône Constrain Proportions / "conserver les proportions de mise à l'échelle"
                du panneau Transformation ou du panneau Contrôle, d'ailleurs les états de 
                ces 2 icônes équivalentes à ces 2 emplacements différents ne sont pas synchronisés.
                La touche majuscule permettra donc à l'utilisateur de contraindre les proportions. 
            */
            if (ScriptUI.environment.keyboardState.shiftKey) { tf.absoluteHorizontalScale *= s; }
            yScale = tf.verticalScale / 100;
            break;



        /*================================================================================================================================*/
        default: return false;
        /*================================================================================================================================*/



    }

    /* Vérification du résultat */
    ycsrc = c.baseline;
    if (! compenserParangonnage.value) { ycsrc += convertUnits (c.baselineShift, 'POINTS', yUnit) * yScale; }
    if (Math.abs(yctrg - ycsrc) <= tolerance) { return 1; }
    
    /* Si résultat non conforme */
    if (
        actionARealiser.selection.index === 0 && 
        //ycsrc > yctrg && 
        /* ysrc peut aussi être < yctrg */
        tf.textFramePreferences.firstBaselineOffset !== FirstBaseline.FIXED_HEIGHT
    ) {
        tf.textFramePreferences.firstBaselineOffset = FirstBaseline.FIXED_HEIGHT;
        tf.textFramePreferences.minimumFirstBaselineOffset = .1;
        //sans quoi pour une valeur de zéro la baseline n'est pas exactement en haut du bloc mais .01 pt (.0035277777778 mm) en dessous.
        retry = true;
    }
    
    if (retry === true) { return 2; }
        
    alert ({en:"non-compliant result (baseline = ",fr:"Résultat non conforme (ligne de base = "}+ycsrc+")");
    throw new Error(errMsg = {
        en:"The desired value is impossible to get by modifying only the selected parameter "
        +"or the script wasn't fixed for this specific case.",
        fr:"La valeur demandée est impossible à obtenir en agissant uniquement sur le paramètre sélectionné "
        +"ou alors le script n'est pas au point dans le cas de figure présent."
    });
}