﻿/******************************************************************/
/*                                                                */
/*                Author: Frédéric ROBIN                          */
/*                https://linktr.ee/robinfredericf                */
/*                                                                */
/******************************************************************/

#target Illustrator

$.localize = true;
$.locale = null;
//$.locale = "en";

function main () {
    
    function getItemsBounds (items) {
        
        var numericSort = function (a, b) { return a - b; };
        
        var p = {}, o = {};
        
        for (var bt in { "visible":0, "geometric":1 }) {
            
            p[bt+"Lefts"] = [];
            p[bt+"Tops"] = [];
            p[bt+"Rights"] = [];
            p[bt+"Bottoms"] = [];
            
            for (var i=0; i<items.length; i++) {
                p[bt+"Lefts"].push(items[i][bt+"Bounds"][0]);
                p[bt+"Tops"].push(items[i][bt+"Bounds"][1]);
                p[bt+"Rights"].push(items[i][bt+"Bounds"][2]);
                p[bt+"Bottoms"].push(items[i][bt+"Bounds"][3]);
            }
            
            p[bt+"Lefts"].sort(numericSort);
            p[bt+"Tops"].sort(numericSort); p[bt+"Tops"].reverse();
            p[bt+"Rights"].sort(numericSort); p[bt+"Rights"].reverse();
            p[bt+"Bottoms"].sort(numericSort);
            
            o[bt+"Bounds"] = [ p[bt+"Lefts"][0], p[bt+"Tops"][0], p[bt+"Rights"][0], p[bt+"Bottoms"][0]];
        }
        
        return o;
    }
    
    function traiterSaisieNumerique (saisie) {
        var formuleMath = /^[0-9\.\,\+\-\*\/\%\(\)]+$/;
        //if (formuleMath.test(saisie)) { alert ("saisie expression mathématique") } else { alert ("saisie n'importe quoi") }
        if (formuleMath.test(saisie)) {
            // Traitement permettant la saisie d'expression mathématiques avec addition soustraction multiplication division modulo et les parenthèses pour gérer les priorités
            saisie = saisie.replace (/\,/g, ".");
            // permet l'évaluation correcte des nombres décimaux saisis avec le format français avec la virgule comme séparateur
            saisie = saisie.replace (/(^|[^\d\.])0+([\d\.]+)/g, "$1$2");
            // supprime les zéros en début de nombres avant l'évaluation de l'expression pour empêcher les décomptes d'être interprétés comme des nombres octaux
            saisie = eval (saisie);
        } else {
            //saisie = saisie.replace (/\D/g, "");
        }
        return Number (saisie);
    }
    
    var baseUnit = {
        'RulerUnits.Unknown':'pt',
        'RulerUnits.Inches':'in', 
        'RulerUnits.Centimeters':'cm', 
        'RulerUnits.Points':'pt', 
        'RulerUnits.Picas':'pc', 
        'RulerUnits.Millimeters':'mm', 
        'RulerUnits.Qs':'pt', 
        'RulerUnits.Pixels':'px'
    }[app.activeDocument.rulerUnits];
    
    var boundsTypeSelection, cb0Value, cb1Value, cb2Value, cb3Value, margin;
    var prefsPath = File($.fileName).name.toString().replace(/\W/g, '');
    try { 
        boundsTypeSelection = app.preferences.getIntegerPreference(prefsPath + "/boundsTypeSelection"); 
        if (boundsTypeSelection < 0 || boundsTypeSelection > 1) { throw new Error; } 
    } catch(e) { boundsTypeSelection = 0; }
    try { cb0Value = Boolean(app.preferences.getBooleanPreference(prefsPath + "/cb0Value")); } catch(e) { cb0Value = true; }
    try { cb1Value = Boolean(app.preferences.getBooleanPreference(prefsPath + "/cb1Value")); } catch(e) { cb1Value = true; }
    try { cb2Value = Boolean(app.preferences.getBooleanPreference(prefsPath + "/cb2Value")); } catch(e) { cb2Value = true; }
    try { cb3Value = Boolean(app.preferences.getBooleanPreference(prefsPath + "/cb3Value")); } catch(e) { cb3Value = true; }
    try { 
        margin = app.preferences.getRealPreference(prefsPath + "/margin"); 
        if (1/margin > 10e14) { throw new Error; } 
    } catch(e) { margin = 0; }
    
    while (true) {
        var w = new Window (
            'dialog', 
            { fr: "Ajuster le plan de travail à la sélection…", en: "Fit artboard to selected art…" }
        );
        w.add (
            'statictext', 
            undefined, 
            { fr: "Ajuster le plan de travail actif \r", en: "Fit active artboard \r" }
                + app.activeDocument.artboards[app.activeDocument.artboards.getActiveArtboardIndex()].name + "\r"
                + { fr: "aux éléments sélectionnés", en:"to selected items" }, 
            {multiline:true}
        );
        var boundsType = w.add (
            'dropdownlist', 
            undefined, 
            [
                { fr:"Incluant l'épaisseur des contours", en:"Including stroke weight" },
                { fr:"Excluant l'épaisseur des contours", en:"Excluding stroke weight" } 
            ]
        );
        boundsType.selection = boundsTypeSelection;
        with (w.add ('group', undefined, undefined, {orientation:'row'})) {
            var cb0 = add('checkbox', undefined, { fr: "Gauche", en: "Left"   }); cb0.value = cb0Value;
            var cb1 = add('checkbox', undefined, { fr: "Haut",   en: "Top"    }); cb1.value = cb1Value;
            var cb2 = add('checkbox', undefined, { fr: "Droite", en: "Right"  }); cb2.value = cb2Value;
            var cb3 = add('checkbox', undefined, { fr: "Bas",    en: "Bottom" }); cb3.value = cb3Value;
        }
        with (w.add ('group', undefined, undefined, {orientation:'row'})) {
            add ('statictext', undefined, {fr:"Marge :", en:"Margin:"}); 
            var mtxt = add('edittext',  undefined, margin.toLocaleString()); mtxt.characters = 20;
            add ('statictext', undefined, baseUnit);
        }
        with (w.add ('group', undefined, undefined, {orientation:'row'})) {
            add ('button', undefined, "OK");
            add ('button', undefined, "Cancel");
        }
        
        if (app.activeDocument.selection.length == 0 || w.show() != 1) { return false; }
        
        
        boundsTypeSelection = boundsType.selection.index;
        cb0Value = cb0.value;
        cb1Value = cb1.value;
        cb2Value = cb2.value;
        cb3Value = cb3.value;
        margin = traiterSaisieNumerique (mtxt.text);
        
        if (isNaN (margin)) { continue; }
        
        var dims = getItemsBounds(app.activeDocument.selection);
        var bounds = [ "visibleBounds", "geometricBounds" ][boundsTypeSelection];
        var ab = app.activeDocument.artboards[app.activeDocument.artboards.getActiveArtboardIndex()];
        var abr = ab.artboardRect;
        if (cb0Value) { abr[0] = dims[bounds][0] - UnitValue (margin, baseUnit).as('pt'); }
        if (cb1Value) { abr[1] = dims[bounds][1] + UnitValue (margin, baseUnit).as('pt'); }
        if (cb2Value) { abr[2] = dims[bounds][2] + UnitValue (margin, baseUnit).as('pt'); }
        if (cb3Value) { abr[3] = dims[bounds][3] - UnitValue (margin, baseUnit).as('pt'); }
        ab.artboardRect = abr;
        
        app.preferences.setIntegerPreference(prefsPath + "/boundsTypeSelection", boundsTypeSelection);
        app.preferences.setBooleanPreference(prefsPath + "/cb0Value", cb0Value);
        app.preferences.setBooleanPreference(prefsPath + "/cb1Value", cb1Value);
        app.preferences.setBooleanPreference(prefsPath + "/cb2Value", cb2Value);
        app.preferences.setBooleanPreference(prefsPath + "/cb3Value", cb3Value);
        app.preferences.setRealPreference(prefsPath + "/margin", margin);
        return true;
    }
    return false;
}

try { main (); } catch(e) { alert (e); }
