﻿/******************************************************************/
/*                                                                */
/*                Author: Frédéric ROBIN                          */
/*                https://linktr.ee/robinfredericf                */
/*                                                                */
/******************************************************************/

#target Illustrator

$.localize = true;
$.locale = null;
//$.locale = "en";

function main () {
    
    function traiterSaisieNumerique (saisie) {
        var formuleMath = /^[0-9\.\,\+\-\*\/\%\(\)]+$/;
        //if (formuleMath.test(saisie)) { alert ("saisie expression mathématique") } else { alert ("saisie n'importe quoi") }
        if (formuleMath.test(saisie)) {
            // Traitement permettant la saisie d'expression mathématiques avec addition soustraction multiplication division modulo et les parenthèses pour gérer les priorités
            saisie = saisie.replace (/\,/g, ".");
            // permet l'évaluation correcte des nombres décimaux saisis avec le format français avec la virgule comme séparateur
            saisie = saisie.replace (/(^|[^\d\.])0+([\d\.]+)/g, "$1$2");
            // supprime les zéros en début de nombres avant l'évaluation de l'expression pour empêcher les décomptes d'être interprétés comme des nombres octaux
            saisie = eval (saisie);
        } else {
            //saisie = saisie.replace (/\D/g, "");
        }
        return Number (saisie);
    }

    var dX, dY, orderSelection;
    var prefsPath = File($.fileName).name.toString().replace(/\W/g, '');
    try { 
        dX = app.preferences.getRealPreference(prefsPath + "/dX"); 
        if (1/dX > 10e14) { throw new Error; } 
    } catch(e) { dX = 0; }
    try { 
        dY = app.preferences.getRealPreference(prefsPath + "/dY"); 
        if (1/dY > 10e14) { throw new Error; } 
    } catch(e) { dY = 0; }
    try { 
        orderSelection = app.preferences.getIntegerPreference(prefsPath + "/orderSelection"); 
        if (orderSelection < 0 || orderSelection > 3) { throw new Error; } 
    } catch(e) { orderSelection = 2; }
    
    var baseUnit = {
        'RulerUnits.Unknown':'pt', 
        'RulerUnits.Inches':'in', 
        'RulerUnits.Centimeters':'cm', 
        'RulerUnits.Points':'pt', 
        'RulerUnits.Picas':'pc', 
        'RulerUnits.Millimeters':'mm', 
        'RulerUnits.Qs':'pt', 
        'RulerUnits.Pixels':'px'
    }[app.activeDocument.rulerUnits];
    var artbs = app.activeDocument.artboards;
    var refartbindex = artbs.getActiveArtboardIndex();
    var refartb = artbs[refartbindex];

    while (true) {
        var w = new Window (
            'dialog', 
                { 
                    fr: "Nouveau plan de travail d'après celui sélectionné",
                    en: "New artboard based on the selected one"
                }
            );
        w.add (
            'statictext', 
            undefined, 
            {
                fr: "Créer un nouveau plan de travail \rd'après ",
                en: "Create a new artboard \rbased on "
            } 
                + refartb.name,
            {multiline:true}
        );
        with (w.add ('group', undefined, undefined, {orientation:'row'})) {
            add ('statictext', undefined, {fr:"Décalage X :", en:"X offset:"}); 
            var dXtxt = add('edittext',  undefined, dX.toLocaleString()); dXtxt.characters = 32;
            add ('statictext', undefined, baseUnit);
        }
        with (w.add ('group', undefined, undefined, {orientation:'row'})) {
            add ('statictext', undefined, {fr:"Décalage Y :", en:"Y offset:"});
            var dYtxt = add('edittext',  undefined, dY.toLocaleString()); dYtxt.characters = 32; 
            add ('statictext', undefined, baseUnit);
        }
        with (w.add ('group', undefined, undefined, {orientation:'row'})) {
            add (
                'statictext', 
                undefined, 
                {fr:"Nom du nouveau plan de travail : ", en:"Name of the new artboard: "}
            );
            var newartbname = add (
                'edittext',  
                undefined, 
                new String ({fr:"Plan de travail ", en:"Artboard "} + Number (artbs.length + 1))
            );
            newartbname.characters = 32;
        }
        with (w.add ('group', undefined, undefined, {orientation:'row'})) {
            add (
                'statictext', 
                undefined, 
                {fr:"Ordre du nouveau plan de travail : ",en:"Order of the new artboard: "}
            );
            var order = add (
                'dropdownlist',
                undefined,
                [
                    {fr:"Au début de la liste des plans de travail", en:"At the begining of the artboards list"},
                    {fr:"Avant celui sélectionné", en:"Before the selected one"},
                    {fr:"Après celui sélectionné", en:"After the selected one"},
                    {fr:"A la fin de la liste des plans de travail", en:"At the end of the artboards list"}
                ]
            );
            order.selection = orderSelection;
        }
        with (w.add ('group', undefined, undefined, {orientation:'row'})) {
            add ('button', undefined, "OK");
            add ('button', undefined, "Cancel");
        }

        if (w.show() !== 1) { return false; }
        
        dX = traiterSaisieNumerique (dXtxt.text);
        dY = traiterSaisieNumerique (dYtxt.text);
        orderSelection = order.selection.index;
        
        if (isNaN (dX) | isNaN (dY)) { continue; }
        
        var newartb;
        var newartbindex = [ 0, refartbindex, refartbindex + 1, artbs.length ][orderSelection];
        app.activeDocument.artboards.insert(
            [
                refartb.artboardRect[0] + UnitValue (dX, baseUnit).as('pt'), 
                refartb.artboardRect[1] - UnitValue (dY, baseUnit).as('pt'), 
                refartb.artboardRect[2] + UnitValue (dX, baseUnit).as('pt'), 
                refartb.artboardRect[3] - UnitValue (dY, baseUnit).as('pt') 
            ],
            newartbindex
        );
        newartb = artbs[newartbindex];
        newartb.name = newartbname.text; 
        
        app.preferences.setRealPreference(prefsPath + "/dX", dX);
        app.preferences.setRealPreference(prefsPath + "/dY", dY);
        app.preferences.setIntegerPreference(prefsPath + "/orderSelection", orderSelection);
        return true;
    }
    return false;
}

try { main (); } catch(e) { alert (e); }
