﻿/******************************************************************/
/*                                                                */
/*            Author: Frédéric ROBIN (robinfredericf)             */
/*                                                                */
/*        http://robinfredericf.free.fr                           */
/*        http://www.linkedin.com/in/robinfredericf/en            */
/*        http://fr.viadeo.com/fr/profile/robinfredericf          */
/*        http://plus.google.com/u/0/112815740483397412444        */
/*                                                                */
/*                    robinfredericfҨgmaїl·cѳm                    */
/*                                                                */
/******************************************************************/

#target "Illustrator"


$.localize = true;
$.locale = null;
//$.locale = 'en';





function getSelectionAllPageItems() {
    //Version Illustrator
    var selectionAllPageItems = [];
    for (var i=0; i<app.activeDocument.pageItems.length; i++) {
        if (app.activeDocument.pageItems[i].selected) {
            selectionAllPageItems.push(app.activeDocument.pageItems[i]);
        }
    }
    return selectionAllPageItems;
}

function getSelectionAllCharacters() {
    //Cas le plus simple (Illustrator): l'utilisateur a sélectionné une partie des caractères d'un textFrame avec l'outil texte
    if ('characters' in app.activeDocument.selection) { return app.activeDocument.selection.characters; }
    //Cas général (Illustrator / InDesign) Etablissement de la liste des Characters, y compris ceux dans des sous-groupes, parmi les éléments sélectionnés
    var theChars = [];
    var selectionAllPageItems = getSelectionAllPageItems();
    for (var i=0; i<selectionAllPageItems.length; i++) {
        if (! ('characters' in selectionAllPageItems[i])) { continue; }
        for (var j=0; j<selectionAllPageItems[i].characters.length; j++) {
            theChars.push(selectionAllPageItems[i].characters[j]);
        }
    }
    return theChars;
}

function main() {
    var theChars = getSelectionAllCharacters();
    var charsH = 0, charsV = 0;
    for (var i=0 ; i<theChars.length ; i++) {
        var c = theChars[i];
        charsH += (c.horizontalScale !== 100) ? 1 : 0;
        charsV += (c.verticalScale   !== 100) ? 1 : 0;
    }
    var rapport = "Sur les " + theChars.length + " caractères compris dans la sélection \r\n"
        + charsH + " ont actuellement une échelle horizontale appliquée \r\n"
        + charsV + " ont actuellement une échelle verticale appliquée";
    //alert (rapport);
    var w = new Window ('dialog');
    w.add ('statictext', undefined, {
        fr:"Inverser l'échelle horizontale/verticale des caractères en préservant l'aspect :",
        en:"Invert characters horizontal/vertical scale while preserving the appearance:"
    });
    var choixEchelleHV = w.add (
        'dropdownlist',
        undefined,
        [
            {
                fr:"Mettre l'échelle verticale à 100 %, ajuster l'échelle horizontale et le corps en conséquence.",
                en:"Set vertical scale to 100%, ajust horizontal scale and font size accordingly."
            },
            {
                fr:"Mettre l'échelle horizontale à 100 %, ajuster l'échelle verticale et le corps en conséquence.",
                en:"Set horizontal scale to 100%, ajust vertical scale and font size accordingly."
            }
        ]
    );
    choixEchelleHV.selection = (charsV < charsH) ? 1 : 0;
    with (w.add ('group',undefined,undefined,{orientation:'row'})) {add('button',undefined,'Cancel');add('button',undefined,'OK');alignment='right';}

    if (w.show() !== 1) { return false; }
    
    for (var i=0 ; i<theChars.length ; i++) {
        var c = theChars[i];
        switch (choixEchelleHV.selection.index) {
            case 0 :
                c.size *= c.verticalScale / 100 ;
                c.horizontalScale *= 100 / c.verticalScale ;
                c.verticalScale = 100 ;
                break ;
            case 1 :
                c.size *= c.horizontalScale / 100 ;
                c.verticalScale *= 100 / c.horizontalScale ;
                c.horizontalScale = 100 ;
                break ;
        }
    }
}

main();