﻿#target "InDesign"


$.localize = true;
$.locale = null;
//$.locale = "en";


var centVingtSeptMillimetres = {
    /*
        pour chaque unité sélectionnée dans les préférences d'unité de mesure d'InDesign
        on répertorie les dimensions affichées d'un carré de 127 mm.
        Les unités désactivées sont supposées exister d'après
        http://jongware.mit.edu/idcs5js/pc_ViewPreference.html
        mais ne peuvent être sélectionnées ni par la
        fenêtre des préférences ni par javascript.
        Pour CUSTOM « Personnalisées » on est supposé spécifier un nombre de points
        (12 par défaut) mais l'affichage des dimensions est toujours en points.
    */
    POINTS: 360,
    PICAS: 30,
    INCHES: 5,
    INCHES_DECIMAL: 5,
    MILLIMETERS: 127,
    CENTIMETERS: 12.7,
    CICEROS: 84.455/3, //soit 28.1516666666899
    CUSTOM: 360,
    AGATES: 70,
    //U
    //BAI
    //MILS
    PIXELS: 360,
    //Q
    //HA
    //AMERICAN_POINTS
};
function convertUnits (n0, u0, u1) {
    var n1 = n0 * centVingtSeptMillimetres[u1] / centVingtSeptMillimetres[u0];
    //$.writeln (n0 + " " + u0 + " \u2192 " + n1 + " " + u1);
    return n1;
}

var w = new Window ("dialog", File($.fileName).name) ;
w.add ("statictext", undefined, {en:"Convert ",fr:"Convertir "}) ;
var a2b = w.add ("checkbox", undefined, {en:"rule above to rule below",fr:"filet supérieur en filet inférieur"}) ;
var b2a = w.add ("checkbox", undefined, {en:"rule below to rule above",fr:"filet inferieur en filet supérieur"}) ;
with (w.add ('group',undefined,undefined,{orientation:'row'})) {add('button',undefined,'Cancel');add('button',undefined,'OK');}


if (w.show() === 1) {
    try { 
        app.doScript(
            function() { permuterFilets () ; },
            ScriptLanguage.JAVASCRIPT,
            undefined,
            UndoModes.ENTIRE_SCRIPT,
            File($.fileName).name
        ) ;
    } catch(e) { alert(e); }
}

function permuterFilets () {
    var props = [
        '', 
        'Color', 
        'GapColor', 
        'GapOverprint', 
        'GapTint', 
        'LeftIndent', 
        'LineWeight', 
        //'Offset', // sera traité à part 
        'Overprint', 
        'RightIndent', 
        'Tint', 
        'Type', 
        'Width', 
    ] ;
    var c = app.activeDocument.selection[0].characters[0] ;
    var cbak = c.properties ;
    for (var p=0 ; p<props.length ; p++) {
        if (a2b.value) { c['ruleBelow'+props[p]] = cbak['ruleAbove'+props[p]] ; }
        if (b2a.value) { c['ruleAbove'+props[p]] = cbak['ruleBelow'+props[p]] ; }
    } ;
    var yUnit = app.activeDocument.viewPreferences.verticalMeasurementUnits;
    if (a2b.value) { c.ruleBelowOffset = - cbak.ruleAboveOffset - convertUnits(cbak.ruleAboveLineWeight, 'POINTS', yUnit) ; } 
    if (b2a.value) { c.ruleAboveOffset = - cbak.ruleBelowOffset - convertUnits(cbak.ruleBelowLineWeight, 'POINTS', yUnit) ; } 
} ;